﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Windows.Forms;
using System.IO;

namespace Grupa_H
{
    public partial class Form1 : Form
    {
        int[,] podaci = new int[10991, 5];
        public Form1()
        {
            InitializeComponent();

            try
            {
                StreamReader reader = new StreamReader("podaciH.txt");
                int trenutniRedak = 0;

                while (!reader.EndOfStream)
                {
                    string linija = reader.ReadLine();
                    string[] dijeloviLinije = linija.Split('-');

                    podaci[trenutniRedak, 0] = Convert.ToInt32(dijeloviLinije[0]);
                    podaci[trenutniRedak, 1] = Convert.ToInt32(dijeloviLinije[1]);
                    podaci[trenutniRedak, 2] = Convert.ToInt32(dijeloviLinije[2]);
                    podaci[trenutniRedak, 3] = Convert.ToInt32(dijeloviLinije[3]);
                    podaci[trenutniRedak, 4] = Convert.ToInt32(dijeloviLinije[4]);

                    trenutniRedak++;
                }

                reader.Close();

                MessageBox.Show("Podaci su učitani!");
            }
            catch (Exception ex)
            {
                MessageBox.Show("Greška: " + ex.Message);
            }
        }

        static bool iznadOgranicenja(double v, double vogr)
        {
            if (v > (vogr * 1.1))
            {
                return true;
            }
            else
            {
                return false;
            }
        }

        private void btnDohvat_Click(object sender, EventArgs e)
        {
            int zeljeniIndeks = Convert.ToInt32(txtIndeksRetka.Text);

            txtVrijeme.Text = podaci[zeljeniIndeks, 2] + ":" + podaci[zeljeniIndeks, 3] + ":" + podaci[zeljeniIndeks, 4];
            txtBrzina.Text = podaci[zeljeniIndeks, 1] + " km/h";
            txtVoziloID.Text = Convert.ToString(podaci[zeljeniIndeks, 0]);
        }

        private void btnDohvatiBrzineIznad_Click(object sender, EventArgs e)
        {
            int vogr = Convert.ToInt32(txtOgranicenje.Text);
            int najvecaBrzina = int.MinValue;

            string ispis = "VoziloID\tVrijeme\tBrzina[km/h]\n";

            for (int i = 0; i < podaci.GetLength(0); i++)
            {
                if (iznadOgranicenja(podaci[i, 1], vogr))
                {
                    ispis += podaci[i, 0] + "\t"
                        + podaci[i, 2] + ":" + podaci[i, 3] + ":" + podaci[i, 4] + "\t"
                        + podaci[i, 1] + "\n";
                }

                if (podaci[i, 1] > najvecaBrzina)
                {
                    najvecaBrzina = podaci[i, 1];
                }
            }
            richTextIznadOgranicenja.Text = ispis;
            txtMaxBrzina.Text = najvecaBrzina + " km/h";
        }
    }
}